function fit_logist(x,y)
[x,xi]=sort(x,'ascend');y=y(xi);

HalfWindowSize=15;A=normpdf([-2:2/HalfWindowSize:2],0,1);A=A/sum(A);
yft=filtfilt(A,1,y);
syf=sort(yft,'descend');
maxyf=max(yft);;
minyf=min(yft);
cpyf=mean([maxyf minyf]);
a=find(syf<cpyf);
b=find(yft==syf(a(1)) );

yo = minyf;
ym = maxyf;
yf = minyf;
T  = 1;
r  = -0.001;
d  = x(b);
%{
yo = minyf;
ym = maxyf;
yf = minyf;
r  = -0.01;
d  = 1500;
beta=[yo yi yf r d];
beta = nlinfit(x,y,'logistic_growth',beta);
yf=logistic_decay(beta, x);

y=max(y)-y;
beta=[yo ym r d];
beta = nlinfit(x,y,'logistic_growth',beta);
yf=logistic_growth(beta, x);
%}

beta=[yo ym T r d];
beta = nlinfit(x,y,'richards_growth',beta);
yf=richards_growth(beta, x);

plot(x,y,'*b',x,yf,'r*')
ERR=(y-yf);
SE=ERR.^2;
R2=1-sum(SE)/sum((y-mean(y)).^2);
ME=mean(ERR);
RMSE=sqrt(mean(SE));
disp(beta)
disp([R2 RMSE])